---
generated_at: 2026-02-04 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-型格子（Type Lattice）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 全ての主張にソースコード根拠が確認されている

## 2) 参照した情報（Evidence一覧）

- E-01: `Compiler/src/typelattice.jl` 44-61行目 - Conditional 構造体定義
- E-02: `Compiler/src/typelattice.jl` 94-111行目 - MustAlias 構造体定義
- E-03: `Compiler/src/typelattice.jl` 118-134行目 - InterMustAlias 構造体定義
- E-04: `Compiler/src/typelattice.jl` 142-149行目 - PartialTypeVar 構造体定義
- E-05: `Compiler/src/typelattice.jl` 208-216行目 - LimitedAccuracy 構造体定義
- E-06: `Compiler/src/typelattice.jl` 218-229行目 - NotFound / NOT_FOUND 定義
- E-07: `Compiler/src/typelattice.jl` 238-244行目 - assert_nested_slotwrapper
- E-08: `Compiler/src/typelattice.jl` 258-271行目 - widenconditional
- E-09: `Compiler/src/typelattice.jl` 314-321行目 - widenmustalias
- E-10: `Compiler/src/typelattice.jl` 395-412行目 - ⊑(InferenceLattice)
- E-11: `Compiler/src/typelattice.jl` 414-439行目 - ⊑(AnyConditionalsLattice)
- E-12: `Compiler/src/typelattice.jl` 454-530行目 - ⊑(PartialsLattice)
- E-13: `Compiler/src/typelattice.jl` 532-552行目 - ⊑(ConstsLattice)
- E-14: `Compiler/src/typelattice.jl` 728-733行目 - smerge
- E-15: `Compiler/src/typelattice.jl` 738-754行目 - stupdate!
- E-16: `Compiler/src/typelimits.jl` 7-8行目 - MAX_TYPEUNION_COMPLEXITY/LENGTH
- E-17: `Compiler/src/typelimits.jl` 17-33行目 - limit_type_size
- E-18: `Compiler/src/typelimits.jl` 223-307行目 - type_more_complex
- E-19: `Compiler/src/typelimits.jl` 779-893行目 - tmerge_types_slow
- E-20: `Compiler/src/abstractlattice.jl` 7-96行目 - 格子層定義
- E-21: `Compiler/src/abstractlattice.jl` 144-181行目 - ⊑/⊏/⋤/is_lattice_equal 定義
- E-22: `Compiler/src/abstractlattice.jl` 301-302行目 - fallback_lattice
- E-23: `Compiler/src/typelattice.jl` 11-22行目 - may_form_limited_typ
- E-24: `Compiler/src/typelimits.jl` 440-489行目 - tmerge_limited
- E-25: `Compiler/src/typelimits.jl` 593-676行目 - tmerge_partial_struct
- E-26: `Compiler/src/typelimits.jl` 86-189行目 - _limit_type_size
- E-27: `Compiler/src/typelattice.jl` 66-69行目 - InterConditional(cnd::Conditional)
- E-28: `docs/code-to-docs/機能一覧/機能一覧.csv` 81行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Conditional は slot/ssadef/thentype/elsetype/isdefined を持つ | E-01 | ○ |
| C-02 | MustAlias は slot/ssadef/vartyp/fldidx/fldtyp を持つ | E-02 | ○ |
| C-03 | InterMustAlias は MustAlias のプロシージャ間版で ssadef を持たない | E-03 | ○ |
| C-04 | PartialTypeVar は TypeVar の lb_certain/ub_certain を追跡する | E-04 | ○ |
| C-05 | LimitedAccuracy は typ + causes(IdSet{InferenceState}) を保持し入れ子禁止 | E-05 | ○ |
| C-06 | NotFound/NOT_FOUND は未解析 SSA 値を表すシングルトン | E-06 | ○ |
| C-07 | assert_nested_slotwrapper で Conditional/MustAlias の入れ子が禁止される | E-07 | ○ |
| C-08 | widenconditional は thentype===Bottom なら Const(false)、elsetype===Bottom なら Const(true) を返す | E-08 | ○ |
| C-09 | widenmustalias は fldtyp を返す | E-09 | ○ |
| C-10 | ⊑(InferenceLattice) は ignorelimited 後に比較し、b が LimitedAccuracy なら causes ⊆ も確認 | E-10 | ○ |
| C-11 | ⊑(AnyConditionalsLattice) は issubconditional で Conditional 同士を比較 | E-11 | ○ |
| C-12 | ⊑(PartialsLattice) は PartialStruct のフィールドごとに再帰的に ⊑ 判定 | E-12 | ○ |
| C-13 | ⊑(ConstsLattice) は Const 同士を val === で比較 | E-13 | ○ |
| C-14 | smerge は VarState に対して tmerge + undef フラグの or 結合 | E-14 | ○ |
| C-15 | stupdate! は join_pc によるパス収束基準で SSA 構築 | E-15 | ○ |
| C-16 | MAX_TYPEUNION_COMPLEXITY=3、MAX_TYPEUNION_LENGTH=3 | E-16 | ○ |
| C-17 | limit_type_size は type_more_complex が true の場合のみ _limit_type_size を適用 | E-17 | ○ |
| C-18 | tmerge_types_slow は同名 TypeName のペアを wrapper に拡大して Union を簡約化 | E-19 | ○ |
| C-19 | 格子層の積み重ねは JLTypeLattice→ConstsLattice→PartialsLattice→ConditionalsLattice→...→InferenceLattice | E-20 | ○ |
| C-20 | may_form_limited_typ により Conditional/MustAlias の引数に LimitedAccuracy があると自動ラップ | E-23, E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠が確認されている
- 1: 中リスク - typelattice.jl/typelimits.jl は大規模ファイルであり、tmerge の全パターンの網羅的検証には追加レビューが有益

## 6) レビュアーチェックリスト（最小）
- [ ] 格子層の積み重ね順序と widenlattice の委譲チェーンが正確に記述されているか確認
- [ ] ⊑(InferenceLattice) の LimitedAccuracy 処理ロジック（causes ⊆ 判定）が正確か確認
- [ ] tmerge_types_slow の Union 簡約化ロジック（tname_intersect + tuplemerge）の記述が正確か確認
- [ ] PartialStruct コンストラクタの undefs 引数の扱いが正確に記述されているか確認
